package gov.va.med.mhv.rxrefill.data.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.hibernate.annotations.Type;

@Entity
@Table(name = "PRESCRIPTIONS")
public class Prescription implements Serializable {

	private static final long serialVersionUID = -4959882821766779165L;

	@Id
	@Column(name = "PRESCRIPTION_ID")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;

	@Column(name = "OPLOCK")
	private Integer oplock = 1;

	@Column(name = "CREATED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date createdDate;

	@Column(name = "REFILLABLE", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean isRefillable;

	@Column(name = "PLACER_ORDER_NUMBER")
	private String placerOrderNumber;

	@Column(name = "USER_ID_SEQ")
	private Long userId;

	/*@Column(name = "USER_ID_SEQ", insertable = false, updatable = false)
	private Long userId;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "USER_ID_SEQ")
	private UserProfile userProfile;*/

	@Column(name = "IEN")
	private String ien;

	@Column(name = "PROVIDER_FIRST_NAME")
	private String providerFirstName;

	@Column(name = "PROVIDER_ID")
	private String providerId;

	@Column(name = "DIVISION")
	private Long division;

	@Column(name = "INACTIVE", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean isInactive = Boolean.FALSE;

	@Column(name = "SIG")
	private String sig;

	@Column(name = "MAIL_WINDOW")
	private String mailWindow;

	@Column(name = "RELEASE_DATE_TIME")
	@Temporal(TemporalType.TIMESTAMP)
	private Date releaseDateTime;

	@Column(name = "INVALID_MHV_STATUS", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean isInvalidMhvStatus;

	@Column(name = "PRESCRIPTION_NUMBER", nullable=false)
	private String prescriptionNumber;

	@Column(name = "EXPIRATION_CANCEL_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date expirationCancelDate;

	@Column(name = "PROVIDER_LAST_NAME")
	private String providerLastName;

	@Column(name = "QUANTITY")
	private BigDecimal quantity;

	@Column(name = "MHV_STATUS_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date mhvStatusDate;

	@Column(name = "LAST_FILL_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date lastFillDate;

	@Column(name = "REMARKS")
	private String remarks;

	@Column(name = "STATUS")
	private String status;

	@Column(name = "DAYS_SUPPLY")
	private Integer daysSupply;

	@Column(name = "LAST_REFILL_SUBMITTED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date lastRefillSubmittedDate;

	@Column(name = "DIVISION_NAME")
	private String divisionName;

	@Column(name = "ARCHIVED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date archivedDate;

	@Column(name = "DRUG_NAME")
	private String drugName;

	@Column(name = "MODIFIED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date modifiedDate;

	@Column(name = "NUMBER_OF_REFILLS")
	private Integer numberOfRefills;

	@Column(name = "MHV_STATUS")
	private Integer mhvStatus;

	@Column(name = "LAST_REQUEST_SUCCESSFUL", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean isLastRequestSuccessful;

	@Column(name = "ISSUE_DATE_TIME")
	@Temporal(TemporalType.TIMESTAMP)
	private Date issueDateTime;

	/*
	@Column(name = "INSTITUTION_ID", insertable = false, updatable = false)
	private Long institutionId;*/

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "INSTITUTION_ID")
	private Institution institution;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public Boolean getIsRefillable() {
		return isRefillable;
	}

	public void setIsRefillable(Boolean isRefillable) {
		this.isRefillable = isRefillable;
	}

	public String getPlacerOrderNumber() {
		return placerOrderNumber;
	}

	public void setPlacerOrderNumber(String placerOrderNumber) {
		this.placerOrderNumber = placerOrderNumber;
	}

	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	/*public UserProfile getUserProfile() {
		return userProfile;
	}

	public void setUserProfile(UserProfile userProfile) {
		this.userProfile = userProfile;
	}*/

	public String getIen() {
		return ien;
	}

	public void setIen(String ien) {
		this.ien = ien;
	}

	public String getProviderFirstName() {
		return providerFirstName;
	}

	public void setProviderFirstName(String providerFirstName) {
		this.providerFirstName = providerFirstName;
	}

	public String getProviderId() {
		return providerId;
	}

	public void setProviderId(String providerId) {
		this.providerId = providerId;
	}

	public Long getDivision() {
		return division;
	}

	public void setDivision(Long division) {
		this.division = division;
	}

	public Boolean getIsInactive() {
		return isInactive;
	}

	public void setIsInactive(Boolean isInactive) {
		this.isInactive = isInactive;
	}

	public String getSig() {
		return sig;
	}

	public void setSig(String sig) {
		this.sig = sig;
	}

	public String getMailWindow() {
		return mailWindow;
	}

	public void setMailWindow(String mailWindow) {
		this.mailWindow = mailWindow;
	}

	public Date getReleaseDateTime() {
		return releaseDateTime;
	}

	public void setReleaseDateTime(Date releaseDateTime) {
		this.releaseDateTime = releaseDateTime;
	}

	public Boolean getIsInvalidMhvStatus() {
		return isInvalidMhvStatus;
	}

	public void setIsInvalidMhvStatus(Boolean isInvalidMhvStatus) {
		this.isInvalidMhvStatus = isInvalidMhvStatus;
	}

	public String getPrescriptionNumber() {
		return prescriptionNumber;
	}

	public void setPrescriptionNumber(String prescriptionNumber) {
		this.prescriptionNumber = prescriptionNumber;
	}

	public Date getExpirationCancelDate() {
		return expirationCancelDate;
	}

	public void setExpirationCancelDate(Date expirationCancelDate) {
		this.expirationCancelDate = expirationCancelDate;
	}

	public String getProviderLastName() {
		return providerLastName;
	}

	public void setProviderLastName(String providerLastName) {
		this.providerLastName = providerLastName;
	}

	public BigDecimal getQuantity() {
		return quantity;
	}

	public void setQuantity(BigDecimal quantity) {
		this.quantity = quantity;
	}

	public Date getMhvStatusDate() {
		return mhvStatusDate;
	}

	public void setMhvStatusDate(Date mhvStatusDate) {
		this.mhvStatusDate = mhvStatusDate;
	}

	public Date getLastFillDate() {
		return lastFillDate;
	}

	public void setLastFillDate(Date lastFillDate) {
		this.lastFillDate = lastFillDate;
	}

	public String getRemarks() {
		return remarks;
	}

	public void setRemarks(String remarks) {
		this.remarks = remarks;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public Integer getDaysSupply() {
		return daysSupply;
	}

	public void setDaysSupply(Integer daysSupply) {
		this.daysSupply = daysSupply;
	}

	public Date getLastRefillSubmittedDate() {
		return lastRefillSubmittedDate;
	}

	public void setLastRefillSubmittedDate(Date lastRefillSubmittedDate) {
		this.lastRefillSubmittedDate = lastRefillSubmittedDate;
	}

	public String getDivisionName() {
		return divisionName;
	}

	public void setDivisionName(String divisionName) {
		this.divisionName = divisionName;
	}

	public Date getArchivedDate() {
		return archivedDate;
	}

	public void setArchivedDate(Date archivedDate) {
		this.archivedDate = archivedDate;
	}

	public String getDrugName() {
		return drugName;
	}

	public void setDrugName(String drugName) {
		this.drugName = drugName;
	}

	public Date getModifiedDate() {
		return modifiedDate;
	}

	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	public Integer getNumberOfRefills() {
		return numberOfRefills;
	}

	public void setNumberOfRefills(Integer numberOfRefills) {
		this.numberOfRefills = numberOfRefills;
	}

	public Integer getMhvStatus() {
		return mhvStatus;
	}

	public void setMhvStatus(Integer mhvStatus) {
		this.mhvStatus = mhvStatus;
	}

	public Boolean getIsLastRequestSuccessful() {
		return isLastRequestSuccessful;
	}

	public void setIsLastRequestSuccessful(Boolean isLastRequestSuccessful) {
		this.isLastRequestSuccessful = isLastRequestSuccessful;
	}

	public Date getIssueDateTime() {
		return issueDateTime;
	}

	public void setIssueDateTime(Date issueDateTime) {
		this.issueDateTime = issueDateTime;
	}

	/*
	public Long getInstitutionId() {
		return institutionId;
	}

	public void setInstitutionId(Long institutionId) {
		this.institutionId = institutionId;
	}*/

	public Institution getInstitution() {
		return institution;
	}

	public void setInstitution(Institution institution) {
		this.institution = institution;
	}


	public String toString() {
		StringBuffer sb = new StringBuffer();

		sb.append("id : " + id);
		sb.append(", oplock : " + oplock);
		sb.append(", createdDate : " + createdDate);
		sb.append(", isRefillable : " + isRefillable);
		sb.append(", placerOrderNumber : " + placerOrderNumber);
		sb.append(", userId : " + userId);
		sb.append(", ien : " + ien);
		sb.append(", providerFirstName : " + providerFirstName);
		sb.append(", providerId : " + providerId);
		sb.append(", division : " + division);
		sb.append(", isInactive : " + isInactive);
		sb.append(", sig : " + sig);
		sb.append(", mailWindow : " + mailWindow);
		sb.append(", releaseDateTime : " + releaseDateTime);
		sb.append(", isInvalidMhvStatus : " + isInvalidMhvStatus);
		sb.append(", prescriptionNumber : " + prescriptionNumber);
		sb.append(", expirationCancelDate : " + expirationCancelDate);
		sb.append(", providerLastName : " + providerLastName);
		sb.append(", quantity : " + quantity);
		sb.append(", mhvStatusDate : " + mhvStatusDate);
		sb.append(", lastFillDate : " + lastFillDate);
		sb.append(", remarks : " + remarks);
		sb.append(", status : " + status);
		sb.append(", daysSupply : " + daysSupply);
		sb.append(", lastRefillSubmittedDate : " + lastRefillSubmittedDate);
		sb.append(", divisionName : " + divisionName);
		sb.append(", archivedDate : " + archivedDate);
		sb.append(", drugName : " + drugName);
		sb.append(", modifiedDate : " + modifiedDate);
		sb.append(", numberOfRefills : " + numberOfRefills);
		sb.append(", mhvStatus : " + mhvStatus);
		sb.append(", isLastRequestSuccessful : " + isLastRequestSuccessful);
		sb.append(", issueDateTime : " + issueDateTime);
		sb.append(", institution : " + institution);

		return sb.toString();
	}

}
